# **The Hind Rajab Foundation** 

[![Website screenshot][image1]](https://www.hindrajabfoundation.org/)

### **Reviewed By:** Max Brawer, Xavier McCormick

### **Review Date:** April 1, 2025

### **Site Link**: [https://www.hindrajabfoundation.org/](https://www.hindrajabfoundation.org/) 

### **Archive Link:** [https://archive.ph/fwHdb](https://archive.ph/fwHdb)

### **Keywords:** Activism and Advocacy, Political Science, Postcolonial Studies, History, Law and Legal Studies, Justice, Genocide Studies, Accountability, Legal Action, Crimes Against Humanity, Israel, Palestine

### **Data Sources:** 
* Video documentaries hosted on YouTube  
* Multimedia (text and photo) works of journalism (posts, stories)  
* Legal documentation

### **Processes:** 
* Stories are told in the editorial voice of the foundation and its writers  
* Images are selected one per story and curated along with text  
* News stories are collected and presented in curated, standardized format  
* Photographs are stitched together (and in some cases appear to be AI generated)

### **Presentation:** 
The [Hind Rajab Foundation project](https://www.hindrajabfoundation.org/) is a web-based news site that reads like a series of blogs with an RSS feed. Users can browse selected posts with titles, images and words (authored by the foundation) and occasionally watch YouTube videos within a set of categories. Beyond the foundation homepage there are links to social media platforms where the foundation continues its curation. The landing page tells the story in English of the origin of the Foundation and the aims of their work, detailing the core story of Hind Rajab that motivated their work. 

### **Digital Tools Used:** 
* PHP blog template   
* Content management by Weebly  
* References to a MySQL DB  
* Social media platform embeds (X, Instagram, etc.)  
* AWS hosting  
* Vimeo & YouTube

### **Languages:** 
* English  
* On Instagram and social media channels, some content is tailored for:  
  * German  
  * Dutch  
  * Spanish  
  * French

### **Review**  
The [Hind Rajab Foundation](https://www.hindrajabfoundation.org/) emerged as a digital advocacy and legal justice initiative in direct response to the 2023 Israeli assault on Gaza. Named in memory of five-year-old Hind Rajab, who was killed alongside her family in an event emblematic of the broader atrocities in Gaza, the foundation operates as both a tribute and a vehicle for international legal accountability. It is a new project, born from political urgency rather than the digitization of analog content, and affiliated with the March 30 Movement. Its mission is clear: to break the global culture of impunity surrounding crimes against Palestinians through documentation, legal filings, and public advocacy. Unlike many traditional digital archives, this project does not rely on institutional grants or academic infrastructure; rather, it reflects a grassroots legal framework, committed to justice, accountability, and dignity.

<br>
The site functions as a curated digital platform organized into several content categories, including legal updates, editorials, [news briefs](https://www.hindrajabfoundation.org/news), and multimedia. Each story is accompanied by a selected image, often deeply emotional and starkly illustrative, and is written in the voice of the foundation. Many posts document acts of violence or identify accused perpetrators, while others center on the symbolic significance of figures like Hind or respond directly to international events. In some cases, video content hosted via YouTube and Vimeo provides documentary evidence or memorial storytelling. The site links to the foundation's broader social media presence, where content is translated into multiple languages to reach audiences across Europe and beyond. The editorial structure of the site is intentional and direct—it is designed to inform, rally, and pursue action, rather than to serve as an encyclopedic or academic archive.

<br>
From a digital memory standpoint, the site is powerful, but there are aspects that could be refined. Some stories are underdeveloped, with minimal sourcing or unexplained references to legal structures. While the editorial tone is clear and cohesive, there is little opportunity for user engagement or community input. The visual and interactive experience could be deepened: features such as a browsable archive of cases, embedded timelines, or maps would go a long way toward making the platform feel more dynamic and lasting. Similarly, the inclusion of a feed for on-the-ground visual content—photographs or stories submitted by Palestinians and allies—could create a stronger sense of participation and immediacy, while helping distribute narrative control more broadly.

<br>
Still, the Hind Rajab Foundation succeeds in its immediate aims. It makes its position unmistakable, and it does so with clarity and urgency. In a digital landscape where Palestinian voices are often buried, suppressed, or denied legitimacy, this project asserts a powerful counternarrative. Its effectiveness lies in the directness of its storytelling, its alignment with legal structures, and its refusal to separate memory from action. As the foundation continues to evolve, its potential lies not only in naming injustice but in deepening its capacity for participatory justice—welcoming more contributors, expanding its visual archive, and building out the connective tissue between legal strategy and historical remembrance.

### **How are the collaborative aspects reflected in the project and are there elements that work particularly well?** 
The Hind Rajab Foundation reflects collaboration through its integration of legal advocacy, digital storytelling, and grassroots organizing. While the site doesn’t list specific partners, its affiliation with the March 30 Movement and use of multimedia platforms point to behind-the-scenes coordination across disciplines. The project combines legal research, journalism, and media strategy to build a compelling narrative that’s both informative and actionable.

<br>
Though it doesn’t yet include public contribution features like donation or testimony submission, its shareable content and symbolic focus on Hind invite global audiences to participate by witnessing, amplifying, and supporting the cause. This public-facing strategy is where its collaborative impact is most visible.

### **Do you see an opportunity for collaboration that would be helpful to the project?** 
As mentioned in the previous section, crowdsourcing information could be helpful to help scale the project. Because the work is published by a single group from their point of view, the reader may also be interested in seeing non-editorial viewpoints from people on the ground in Israel and Palestine. A visual feed of photography, for example, could add color to the stories and their limited multimedia.

[image1]: <data:image/png;base64,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>